/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.fw.mediasvc.DeviceClassProperties;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceProperties;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

class HdDeviceProperties
extends MediaDeviceProperties {
    private static final String TRACE_MASKT = "XMDAHDPT";
    private static final String TRACE_MASKF = "XMDAHDPF";
    private static final String TRACE_MASKD = "XMDAHDPD";

    HdDeviceProperties(DeviceClassProperties dcp) {
        super(dcp);
        Trace.trace(TRACE_MASKT, "<> HdDeviceProperties.HdDeviceProperties(DeviceClassProperties = " + dcp + ")");
    }

    void setMountPoint(String mountPoint) {
        Trace.trace(TRACE_MASKT, "-> HdDeviceProperties.setMountPoint(mountPoint = " + mountPoint + ")");
        this.mountPoint = mountPoint;
        this.setInternalName();
        try {
            this.setDeviceFile(null);
        }
        catch (MediaDeviceException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- HdDeviceProperties.setMountPoint()");
    }

    void setDeviceFile(String deviceFileName) throws MediaDeviceException {
        Trace.trace(TRACE_MASKT, "-> HdDeviceProperties.setDeviceFile(deviceFileName = " + deviceFileName + ")");
        this.deviceFileSymLink = null;
        try {
            StringTokenizer st;
            String buffer = null;
            FileReader tfr = new FileReader("/etc/fstab");
            BufferedReader tbr = new BufferedReader(tfr);
            while ((buffer = tbr.readLine()) != null && buffer.indexOf(this.mountPoint) == -1) {
            }
            tfr.close();
            if (buffer != null && (st = new StringTokenizer(buffer)).hasMoreTokens()) {
                this.deviceFile = st.nextToken();
            }
            Trace.trace(TRACE_MASKF, "HdDeviceProperties.setDeviceFile(): deviceFile = " + this.deviceFile);
        }
        catch (Exception exc) {
            throw new MediaDeviceException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- HdDeviceProperties.setDeviceFile()");
    }
}

